/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.severing;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SeveringRecipeBuilder
extends AbstractRecipeBuilder<SeveringRecipeBuilder> {
    private final EntityIngredient ingredient;
    private final ItemOutput output;
    private boolean isAgeable = false;
    private ItemOutput childOutput = null;

    public static SeveringRecipeBuilder severing(EntityIngredient ingredient, ItemLike output) {
        return SeveringRecipeBuilder.severing(ingredient, ItemOutput.fromItem((ItemLike)output));
    }

    public SeveringRecipeBuilder setChildOutput(@Nullable ItemOutput childOutput) {
        this.isAgeable = true;
        this.childOutput = childOutput;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Objects.requireNonNull(this.output.get().m_41720_().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "severing");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId));
    }

    private SeveringRecipeBuilder(EntityIngredient ingredient, ItemOutput output) {
        this.ingredient = ingredient;
        this.output = output;
    }

    public static SeveringRecipeBuilder severing(EntityIngredient ingredient, ItemOutput output) {
        return new SeveringRecipeBuilder(ingredient, output);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)SeveringRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            json.add("entity", SeveringRecipeBuilder.this.ingredient.serialize());
            if (SeveringRecipeBuilder.this.isAgeable) {
                json.add("adult_result", SeveringRecipeBuilder.this.output.serialize());
                if (SeveringRecipeBuilder.this.childOutput != null) {
                    json.add("child_result", SeveringRecipeBuilder.this.childOutput.serialize());
                }
            } else {
                json.add("result", SeveringRecipeBuilder.this.output.serialize());
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return SeveringRecipeBuilder.this.isAgeable ? (RecipeSerializer)TinkerModifiers.ageableSeveringSerializer.get() : (RecipeSerializer)TinkerModifiers.severingSerializer.get();
        }
    }
}

